#define HAVE_UNICODE_CONVTABLE 1
#define HAVE_CHARSET_CONVTABLE 1

STATIC CONST ULONG unicodetable[256] =
{
	// 0xA1 - 0xAF
	        0x0104, 0x02D8, 0x0141, 0x00A4, 0x013D, 0x015A, 0x00A7,
	0x00A8, 0x0160, 0x015E, 0x0164, 0x0179, 0x00AD, 0x017D, 0x017B,

	// 0xB0 - 0xBF
	0x00B0, 0x0105, 0x02DB, 0x0142, 0x00B4, 0x013E, 0x015B, 0x02C7,
	0x00B8, 0x0161, 0x015F, 0x0165, 0x017A, 0x02DD, 0x017E, 0x017C,

	// 0xC0 - 0xCF
	0x0154, 0x00C1, 0x00C2, 0x0102, 0x00C4, 0x0139, 0x0106, 0x00C7,
	0x010C, 0x00C9, 0x0118, 0x00CB, 0x011A, 0x00CD, 0x00CE, 0x010E,

	// 0xD0 - 0xDF
	0x0110, 0x0143, 0x0147, 0x00D3, 0x00D4, 0x0150, 0x00D6, 0x00D7,
	0x0158, 0x016E, 0x00DA, 0x0170, 0x00DC, 0x00DD, 0x0162, 0x00DF,

	// 0xE0 - 0xEF
	0x0155, 0x00E1, 0x00E2, 0x0103, 0x00E4, 0x013A, 0x0107, 0x00E7,
	0x010D, 0x00E9, 0x0119, 0x00EB, 0x011B, 0x00ED, 0x00EE, 0x010F,

	// 0xF0 - 0xFF
	0x0111, 0x0144, 0x0148, 0x00F3, 0x00F4, 0x0151, 0x00F6, 0x00F7,
	0x0159, 0x016F, 0x00FA, 0x0171, 0x00FC, 0x00FD, 0x0163, 0x02D9
};

STATIC CONST struct UCS4_ConvTable convtable =
{
	0xA1,
	0xFF,
	unicodetable
};


STATIC CONST UBYTE chartable1[] =    // <0x00A0 - 0x011B>
{
	0xA0,  '?',  '?',  '?', 0xA4,  '?',  '?', 0xA7,
	0xA8,  '?',  '?',  '?',  '?', 0xAD,  '?',  '?',
	0xB0,  '?',  '?',  '?', 0xB4,  '?',  '?',  '?',
	0xB8,  '?',  '?',  '?',  '?',  '?',  '?',  '?',
	 '?',	0xC1, 0xC2,  '?', 0xC4,  '?',  '?', 0xC7,
	 '?',	0xC9,  '?', 0xCB,  '?', 0xCD, 0xCE,  '?',
	 '?',  '?',  '?', 0xD3, 0xD4,  '?', 0xD6, 0xD7,
	 '?',  '?', 0xDA,  '?', 0xDC, 0xDD,  '?', 0xDF,
	 '?', 0xE1, 0xE2,  '?', 0xE4,  '?',  '?', 0xE7,
	 '?',  '?',  '?', 0xEB,  '?', 0xED, 0xEE,  '?',
	 '?',  '?',  '?', 0xF3, 0xF4,  '?', 0xF6, 0xF7,
	 '?',  '?', 0xFA,  '?', 0xFC, 0xFD,  '?',  '?',

	 '?',  '?', 0xC3, 0xE3, 0xA1, 0xB1, 0xC6, 0xE6,
	 '?',  '?',  '?',  '?', 0xC8, 0xE8, 0xCF,	0xEF,
	0xD0, 0xF0,  '?',  '?',  '?',  '?',  '?',  '?',
	0xCA, 0xEA, 0xCC, 0xEC
};


STATIC CONST UBYTE chartable2[] =    // <0x0139 - 0x017E>
{
	0xC5, 0xE5,  '?',  '?', 0xA5, 0xB5,  '?',  '?',
	0xA3, 0xB3, 0xD1, 0xF1,  '?',	 '?', 0xD2, 0xF2,
	 '?',  '?',  '?',  '?',  '?',  '?',  '?', 0xD5,
	0xF5,	 '?',  '?', 0xC0, 0xE0,  '?',  '?', 0xD8,
	0xF8, 0xA6, 0xB6,  '?',  '?', 0xAA,	0xBA, 0xA9,
	0xB9, 0xDE, 0xFE, 0xAB, 0xBB,  '?',  '?',  '?',
	 '?',  '?',  '?',	 '?',  '?', 0xD9, 0xF9, 0xDB,
	0xFB,  '?',  '?',  '?',  '?',  '?',  '?',  '?',
	0xAC, 0xBC, 0xAF, 0xBF, 0xAE, 0xBE
};


STATIC CONST UBYTE chartable3[] =    // <0x02C7 - 0x02DD>
{
	0xB7,  '?',  '?',  '?',  '?',  '?',  '?',  '?',
	 '?',  '?',  '?',  '?',  '?',  '?',  '?',  '?',
	 '?',	0xA2, 0xFF,  '?', 0xB2,  '?', 0xDD
};


STATIC CONST struct UCS4_CharsetConvTable convtable2 =
{
	NULL,
	{
		{ 0x0A0, 0x11B, chartable1 },
		{ 0x139, 0x17E, chartable2 },
		{ 0x2C7, 0x2DD, chartable3 },
		{ 0x000, 0x000, NULL }
	}
};                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
